﻿<?xml version = "1.0" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:GUIRes="urn:GUIRes" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
  <xsl:variable name="persperpage">5</xsl:variable>
  <xsl:variable name="countCh" select="count(//ZONES/SET/CHANNEL/SET)"/>
  <xsl:variable name="numpageCh" select="ceiling($countCh div $persperpage)"/>
  <xsl:variable name="increment" select="number(1)"/>
  <xsl:template name="channelloop">
    <xsl:param name="counter"/>
    <xsl:param name="numpages"/>
    <xsl:if test="$counter &lt;= $numpages">
      <xsl:choose>
        <xsl:when test="$counter &lt; $numpages">
          <xsl:variable name="colwidth" select="500 div $persperpage"/>
          <xsl:call-template name="CHANNEL">
            <xsl:with-param name="pagenum" select="number($counter)"></xsl:with-param>
            <xsl:with-param name="width" select="$colwidth"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="colwidth" select="500 div ($countCh -($counter * $persperpage))"/>
          <xsl:call-template name="CHANNEL">
            <xsl:with-param name="pagenum" select="number($counter)"></xsl:with-param>
            <xsl:with-param name="width">
              <xsl:choose>
                <xsl:when test="$colwidth &gt; 150">150</xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="$colwidth"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:call-template name="channelloop">
        <xsl:with-param name="counter" select="$counter + $increment"/>
        <xsl:with-param name="numpages" select="$numpages"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="CHANNEL">
    <xsl:param name="pagenum"/>
    <xsl:param name="width"/>
    <xsl:variable name="start" select="(number($pagenum)-1) * $persperpage + 1"/>
    <xsl:variable name="end" select="(number($pagenum)-1) * $persperpage + $persperpage"/>

    <tr class="top">
      <xsl:call-template name="ZONES_TABLE">
        <xsl:with-param name="zones" select="//ZONES/SET[(position() &gt;= $start) and (position() &lt;= $end)]"/>
      </xsl:call-template>
    </tr>
  </xsl:template>

  <xsl:template name="ZONES_TABLE">
    <xsl:param name="zones"/>

    <xsl:for-each select="$zones">
      <td>
        <br/>
        <table >
          <thead>
            <tr>
              <th class="channel" colspan="2">
                <xsl:value-of select="./ZnChanCfgZoneZoneName_A9724"/>
              </th>
            </tr>
          </thead>
          <tbody>
            <xsl:call-template name="CHANNELS_ROW">
              <xsl:with-param name="channels" select="./CHANNEL/SET"/>
            </xsl:call-template>
          </tbody>
        </table>
      </td>
    </xsl:for-each>
  </xsl:template>
  
  

  <xsl:template name="CHANNELS_ROW">
    <xsl:param name="channels"/>

    <xsl:for-each select="$channels">
      <xsl:if test="position() = 1">
        <tr>
          <td class ="em_std"/>
          <td class ="em_std"/>
        </tr>
      </xsl:if>
      <tr>
        <td>
          <xsl:value-of select="position()"/>
        </td>
        <td>
          <xsl:call-template name = 'GUI_RES'>
            <xsl:with-param name = 'cp_node' select = './ZnChanCfgChannelsChannelName_A7659'/>           
          </xsl:call-template>
        </td>
      </tr>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="KM_BUTTONS">
    <xsl:for-each select="//KMBUTTON/SET">
      <tr>
        <td class="sep">
          <xsl:value-of select="GUIRes:IncrementRowCount()"/>
        </td>
        <td class="sep">
          <xsl:call-template name ="GUI_RES">
            <xsl:with-param name="cp_node" select="./RadErgoCfgKMButtonName_A22561"/>
          </xsl:call-template>
        </td>
        <td class="sep">
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="./RadErgoCfgKMConventionalKMButtonFeature_A19646"/>
          </xsl:call-template>
        </td>
        <xsl:if test="$trunkingEnabled = 'true'">
          <td class="sep">
            <xsl:call-template name="GUI_RES">
              <xsl:with-param name="cp_node" select="./RadErgoCfgKMTrunkingKMButtonFeature_A19746"/>
            </xsl:call-template>
          </td>
        </xsl:if>
      </tr>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="KEYPAD_BUTTONS">
    <xsl:param name="keypadButtons"/>
    <xsl:if test="count($keypadButtons) > 0">
    <tr>
      <td class="sep" rowspan="{count($keypadButtons)+1}">
        <xsl:value-of select="GUIRes:IncrementRowCount()"/>
      </td>
      <th colspan="3">
        <xsl:call-template name="GUI_LOOK">
          <xsl:with-param name="lookup">Keypad_Buttons</xsl:with-param>
        </xsl:call-template>
      </th>
    </tr>
    </xsl:if>
    <xsl:for-each select="$keypadButtons">
      <tr>
        <xsl:choose>
          <xsl:when test="position() = last()">
            <xsl:text disable-output-escaping="yes">&lt;td class="sep"&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text disable-output-escaping="yes">&lt;td&gt;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="./RadErgCtrlKeypadGeneralKeypadButtonName_A41069"/>
        </xsl:call-template>
        <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
        <xsl:choose>
          <xsl:when test="position() = last()">
            <xsl:text disable-output-escaping="yes">&lt;td class="sep"&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text disable-output-escaping="yes">&lt;td&gt;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="./RadErgCtrlKeypadGeneralKeypadButtonFeature_A41071"/>
        </xsl:call-template>
        <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
        <xsl:if test="$trunkingEnabled = 'true'">
          <xsl:choose>
            <xsl:when test="position() = last()">
              <xsl:text disable-output-escaping="yes">&lt;td class="sep"&gt;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text disable-output-escaping="yes">&lt;td&gt;</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="./RadErgCtrlKeypadGeneralKeypadButtonFeature_A41071"/>
          </xsl:call-template>
          <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
        </xsl:if>
      </tr>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="NAVIGATION_CONTROLS">
    <tr>
      <td class="sep" rowspan="3">
        <xsl:value-of select="GUIRes:IncrementRowCount()"/>
      </td>
      <th colspan="3">
        <xsl:call-template name="GUI_LOOK">
          <xsl:with-param name="lookup">ID_NAVIGATIONCONTROLS</xsl:with-param>
        </xsl:call-template>
      </th>
    </tr>
    <tr>
      <td>
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="//MobileNavigationControlUpButtonName_A41277"/>
        </xsl:call-template>
      </td>
      <td>
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="//MobileNavigationControlUpButton_A41278O9"/>
        </xsl:call-template>
      </td>
      <td>
        <xsl:if test="$trunkingEnabled = 'true'">
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="//MobileNavigationControlUpButton_A41278O9"/>
          </xsl:call-template>
        </xsl:if>
      </td>
    </tr>
    <tr>
      <td class="sep">
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="//MobileNavigationControlDownButtonName_A41277"/>
        </xsl:call-template>
      </td>
      <td class="sep">
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="//MobileNavigationControlDownButton_A41278O9"/>
        </xsl:call-template>
      </td>
      <td class="sep">
        <xsl:if test="$trunkingEnabled = 'true'">
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="//MobileNavigationControlDownButton_A41278O9"/>
          </xsl:call-template>
        </xsl:if>
      </td>
    </tr>
  </xsl:template>

  <xsl:template name="MFK_BUTTONS">
    <xsl:variable name="mfk_button" select="//MOBILEMFKASSIGNMENTCONTROL/SET"/>
    <tr>
      <td class="sep" rowspan="{count($mfk_button)+2}">
        <xsl:value-of select="GUIRes:IncrementRowCount()"/>
      </td>
      <th colspan="3">
        <xsl:call-template name="GUI_LOOK">
          <xsl:with-param name="lookup">ID_MULTIFUNCTIONKNOB</xsl:with-param>
        </xsl:call-template>
      </th>
    </tr>
    <tr>
      <td>
        <xsl:call-template name="GUI_LOOK">
          <xsl:with-param name="lookup">ID_MFKPRESSBEHAVIOR</xsl:with-param>
        </xsl:call-template>
      </td>
      <td>
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="//RadErgoControlO2MFKButtonPress_A42217O7"/>
        </xsl:call-template>
      </td>
      <xsl:if test="$trunkingEnabled = 'true'">
        <td>
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="//RadErgoControlO2MFKButtonPress_A42217O7"/>
          </xsl:call-template>
        </td>
      </xsl:if>
    </tr>
    <xsl:for-each select="$mfk_button">
      <tr>
        <xsl:choose>
          <xsl:when test="position() = last()">
            <xsl:text disable-output-escaping="yes">&lt;td class="sep"&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text disable-output-escaping="yes">&lt;td&gt;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="./O2MFKAssignmentControlName_A41274"/>
        </xsl:call-template>
        <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
        <xsl:choose>
          <xsl:when test="position() = last()">
            <xsl:text disable-output-escaping="yes">&lt;td class="sep"&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text disable-output-escaping="yes">&lt;td&gt;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="GUI_RES">
          <xsl:with-param name="cp_node" select="./RadErgoControlO2MFKFeatureAssignment_A41275"/>
        </xsl:call-template>
        <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
        <xsl:if test="$trunkingEnabled = 'true'">
          <xsl:choose>
            <xsl:when test="position() = last()">
              <xsl:text disable-output-escaping="yes">&lt;td class="sep"&gt;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text disable-output-escaping="yes">&lt;td&gt;</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="./RadErgoControlO2MFKFeatureAssignment_A41275"/>
          </xsl:call-template>
          <xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
        </xsl:if>
      </tr>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="IS_WORLD_WIDE_PRO">
    <xsl:choose>
    <xsl:when test="$product_name = 'APX 4000' or $product_name = 'APX 2000' or $product_name = 'APX 1000' or $product_name = 'APX 4000 Li'">true</xsl:when>
    <xsl:otherwise>false</xsl:otherwise>
      </xsl:choose>
  </xsl:template>
  
  <xsl:template name="IS_3000_MODEL">
    <xsl:choose>
    <xsl:when test="$product_name = 'APX 3000'">true</xsl:when>
    <xsl:otherwise>false</xsl:otherwise>
      </xsl:choose>
  </xsl:template>  
  
  <xsl:template name="GENERAL_RADIO_INFO">
    <table width="100%">
      <tr>
        <td class="sep">
          <xsl:call-template name="GUI_LOOK">
            <xsl:with-param name="lookup">ID_MODELNUMBER</xsl:with-param>
          </xsl:call-template>
        </td>
        <td class="sep">
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="//RadInfoGeneralModelNumber_A8539" />
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td class="sep">
          <xsl:call-template name="GUI_LOOK">
            <xsl:with-param name="lookup">ID_SERIALNUMBER</xsl:with-param>
          </xsl:call-template>
        </td>
        <td class="sep">
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="//RadInfoGeneralSerialNumber_A9122" />
          </xsl:call-template>
        </td>
      </tr>
      <tr>
        <td class="sep">
          <xsl:call-template name="GUI_LOOK">
            <xsl:with-param name="lookup">ID_FLASHCODE</xsl:with-param>
          </xsl:call-template>
        </td>
        <td class="sep">
          <xsl:call-template name="GUI_RES">
            <xsl:with-param name="cp_node" select="//RadInfoFLASHportFLASHcode_A8132" />
          </xsl:call-template>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="GUI_RES">
    <xsl:param name="cp_node"/>
    <xsl:variable name="visible" select = '$cp_node/@Visible'/>
    <xsl:choose>
      <xsl:when test="$visible = 'True'">
        <xsl:choose>
          <xsl:when test="$cp_node/@Ref = 'True'">
            <xsl:choose>
              <xsl:when test="$cp_node/@BLValue = 'NONE' or $cp_node/@BLValue = 'ID_UNASSIGNED'">
                <xsl:call-template name="GUI_LOOK">
                  <xsl:with-param name ="lookup" select="$cp_node/@BLValue"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="GUI_TYPE">
                  <xsl:with-param name ="lookup" select="$cp_node"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$cp_node"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="GUI_LOOK">
          <xsl:with-param name ="lookup">NOT_APPLICABLE</xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="GUI_LOOK">
    <xsl:param name = "lookup"/>
    <xsl:value-of select = 'GUIRes:GetString($lookup)'/>
  </xsl:template>

  <xsl:template name="GUI_TYPE">
    <xsl:param name = "lookup"/>

    <xsl:variable name="ref_set" select="$CONFIG//SET[@Name=$lookup]"/>
    <xsl:variable name="alias" select="$alias_res/ALIAS[@name=name($ref_set/..)]"/>
    <xsl:value-of select="$ref_set/*[name()=$alias]"/>
  </xsl:template>
  
</xsl:stylesheet>